'use strict';

/* --------------------------------------------------------------
 customizer.js 2016-07-13
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

gambio.widgets.module('customizer', [jse.source + '/vendor/jquery-ui-dist/jquery-ui.min.js', gambio.source + '/libs/events'], function (data) {

    'use strict';

    // ########## VARIABLE INITIALIZATION ##########

    var $this = $(this),
        $body = $('body'),
        $window = $(window),
        ajax = null,
        defaults = {
        requestUrl: 'request_port.php?module=GPrint',
        uidSelector: '#gm_gprint_random',
        page: 'product'
    },
        options = $.extend(true, {}, defaults, data),
        module = {};

    /**
     * Add customizer data to cart or wish list.
     *
     * @private
     */
    var _addCustomizerData = function _addCustomizerData(e, d) {

        var formdata = jse.libs.form.getData($this, null, true),
            dataset = $.extend({ 'mode': 'frontend', 'action': e.data.action }, d.dataset, {}, formdata),
            promises = [],
            attributeIdsString = '';

        $('.customizer select[name^="id["], .customizer input[name^="id["]:checked').each(function () {
            var optionId = $(this).attr('name').replace(/id\[(\d+)\]/, '$1');
            attributeIdsString += '{' + optionId + '}' + $(this).val();
        });

        dataset.products_id = dataset.products_id + attributeIdsString + '{' + e.data.random.match(/\d+/) + '}0';

        $this.find('input[type="file"]').each(function () {
            if ($(this).get(0).files.length > 0) {
                var deferred = $.Deferred();
                promises.push(deferred);

                $(this).hide();
                $(this).parent().append('<img src="gm/images/gprint/upload.gif" width="16" height="11" ' + 'class="gm_gprint_loading" id="loading_' + $(this).attr('id') + '" />');

                _upload($(this), dataset, deferred);
            }
        });

        if (promises.length) {
            $.when.apply(undefined, promises).done(function () {
                _send_customizer_data(e, d, dataset);
            }).always(function () {
                var test = 1;
            });
        } else {
            _send_customizer_data(e, d, dataset);
        }
    };

    /**
     * Upload files from customizer form.
     *
     * @private
     */
    var _upload = function _upload(uploadField, dataset, deferred) {
        var filesList = uploadField.get(0).files,
            url = options.requestUrl + '&action=upload&target=' + dataset.target + '&mode=frontend&upload_field_id=' + uploadField.attr('id') + '&products_id=' + dataset.products_id;

        $('.customizer select[name^="properties_values_ids["]').each(function () {
            url += '&properties_values_ids[]=' + $(this).val();
        });

        uploadField.fileupload({
            url: url,
            autoUpload: false,
            dataType: 'json'
        });

        uploadField.fileupload('send', { files: filesList }).done(function (result) {
            var uploadFieldName = uploadField.attr('id'),
                filename = uploadField.val().replace(/C:\\fakepath\\/i, '');

            dataset[uploadFieldName] = filename;
            uploadField.parent().find('img').remove();
            uploadField.show();

            if (result.ERROR) {
                alert(result.ERROR_MESSAGE);
                deferred.reject();
            } else {
                deferred.resolve(result);
            }
        }).fail(function (jqxhr, testStatus, errorThrown) {
            uploadField.parent().find('img').remove();
            uploadField.show();
            deferred.reject();
        });
    };

    /**
     * Send customizer data beloning to a product which is going to be added to the cart.
     *
     * @private
     */
    var _send_customizer_data = function _send_customizer_data(e, d, dataset) {
        ajax = ajax ? ajax.abort() : null;
        ajax = jse.libs.xhr.post({ url: options.requestUrl, data: dataset }, true);

        ajax.done(function () {
            if (d.deferred) {
                d.deferred.resolve(e.data.random);
            }
        }).fail(function () {
            if (d.deferred) {
                d.deferred.reject();
            }
        });
    };

    /**
     * Send customizer data beloning to a wish list product which is going to be added to the cart.
     *
     * @private
     */
    var _wishlist_to_cart = function _wishlist_to_cart(e, d) {
        if (d.dataset.products_id[0].indexOf('}0') === -1) {
            if (d.deferred) {
                d.deferred.resolve();
            }

            return;
        }

        ajax = ajax ? ajax.abort() : null;

        ajax = jse.libs.xhr.post({
            url: options.requestUrl,
            data: {
                action: 'wishlist_to_cart',
                products_id: d.dataset.products_id[0],
                mode: 'frontend'
            }
        }, true);

        ajax.done(function () {
            if (d.deferred) {
                d.deferred.resolve();
            }
        }).fail(function () {
            if (d.deferred) {
                d.deferred.reject();
            }
        });
    };

    /**
     * Delete customizer data belonging to a product which is going to be deleted in cart or wish list.
     *
     * @private
     */
    var _delete = function _delete(e, d) {
        if (d.dataset.products_id[0].indexOf('}0') === -1) {
            if (d.deferred) {
                d.deferred.resolve();
            }

            return;
        }

        var action = 'update_wishlist';
        if (options.page === 'cart') {
            action = 'update_cart';
        }

        ajax = ajax ? ajax.abort() : null;

        ajax = jse.libs.xhr.post({
            url: options.requestUrl,
            data: {
                action: action,
                products_id: d.dataset.products_id[0],
                mode: 'frontend'
            }
        }, true);

        ajax.done(function () {
            if (d.deferred) {
                d.deferred.resolve();
            }
        }).fail(function () {
            if (d.deferred) {
                d.deferred.reject();
            }
        });
    };

    // ########## INITIALIZATION ##########

    /**
     * Init function of the widget
     * @constructor
     */
    module.init = function (done) {
        if (options.page === 'product') {
            var random = $(options.uidSelector).attr('name');
            $body.on(jse.libs.theme.events.ADD_CUSTOMIZER_CART(), { action: 'add_cart', target: 'cart', random: random }, _addCustomizerData);
            $body.on(jse.libs.theme.events.ADD_CUSTOMIZER_WISHLIST(), { action: 'add_wishlist', target: 'wishlist', random: random }, _addCustomizerData);
        }

        $body.on(jse.libs.theme.events.WISHLIST_TO_CART(), _wishlist_to_cart);
        $body.on(jse.libs.theme.events.WISHLIST_CART_DELETE(), _delete);

        $('#gm_gprint_tabs li').on('click', function () {
            $window.trigger(jse.libs.theme.events.STICKYBOX_CONTENT_CHANGE());
        });

        $window.trigger(jse.libs.theme.events.STICKYBOX_CONTENT_CHANGE());

        // jQuery file upload needs to be loaded after jQuery UI.
        var dependencies = [jse.source + '/vendor/blueimp-file-upload/jquery.fileupload.min.js'];

        window.require(dependencies, done);
    };

    // Return data to widget engine
    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
